IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'PDV_RECBTO_TEF_PARC')
BEGIN
	CREATE TABLE [dbo].[PDV_RECBTO_TEF_PARC](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_RECTO_TEF] [int] NOT NULL,
		[PARCELA]	INT NOT NULL,
		[DT_VENCTO]	DATE NOT NULL,
		[VLR_PARC_CARTAO] [money] NOT NULL,
		[VLR_PARC_SAQUE_CARTAO] [money] NOT NULL,
	
	 CONSTRAINT [PK_PDV_RECBTO_TEF_PARC] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_RECTO_TEF] ASC,
		[PARCELA]
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
	ALTER TABLE [dbo].[PDV_RECBTO_TEF_PARC] ADD  CONSTRAINT [DF_PDV_RECBTO_TEF_PARC_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
	ALTER TABLE [dbo].[PDV_RECBTO_TEF_PARC]  ADD  CONSTRAINT [DF_PDV_RECBTO_TEF_PARC_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]
	ALTER TABLE [dbo].[PDV_RECBTO_TEF_PARC]  ADD  CONSTRAINT [DF_PDV_RECBTO_TEF_PARC_CD_RECTO_TEF]  DEFAULT ((0)) FOR [CD_RECTO_TEF]
	ALTER TABLE [dbo].[PDV_RECBTO_TEF_PARC]  ADD  CONSTRAINT [DF_PDV_RECBTO_TEF_PARC_CD_ADM_CARTAO]  DEFAULT ((1)) FOR [PARCELA]
	ALTER TABLE [dbo].[PDV_RECBTO_TEF_PARC]  WITH CHECK ADD  CONSTRAINT [FK_PDV_RECBTO_TEF_PARC_PDV_RECBTO_TEF_PARC] FOREIGN KEY([CD_EMP],[CD_FILIAL],[CD_RECTO_TEF])
		REFERENCES [dbo].[PDV_RECBTO_TEF] ([CD_EMP],[CD_FILIAL],[CD_RECTO_TEF])  ON DELETE CASCADE ON UPDATE CASCADE
	ALTER TABLE [dbo].[PDV_RECBTO_TEF_PARC] CHECK CONSTRAINT [FK_PDV_RECBTO_TEF_PARC_PDV_RECBTO_TEF_PARC]

END